def pythagoreanTriples(n):
    """
    Returns an iterator which sequences through all the triples
    of integers x, y, z, where x < y < z <= n and x**2 + y**2 = z**2
    """
    for y in range(4,n):
        for x in range(3,y):
            for z in range(5,n+1):
                if x**2 + y**2 == z**2:
                    yield (x, y, z)

it = pythagoreanTriples(100)
try:
    while True:
        x, y, z = next(it)
        print(x,y,z)
except StopIteration as si:
    pass
    

"""
for x, y, z in pythagoreanTriples(50):
    print(x, y, z)
"""

    
